<?php

namespace MarioToscano\Theme\Postype\Artigo;

/**
 * Registra o Post Type de Áreas de Atuação
 */
function register_post_type() {
    $args = array(
        'label'               => 'Artigos',
        'public'              => true,
        'show_in_nav_menus'   => true,
        'query_var'           => true,
        'publicly_queryable'  => true,
        'capability_type'     => 'post',
        'menu_icon'           => 'dashicons-category',
        'has_archive'         => true,
        'taxonomies'          => array('category'),
        'supports'            => array(
            'title',
            'editor',
        ),
        'labels'              => array(
            'name'               => _x( 'Artigos', 'post type general name' ),
            'singular_name'      => _x( 'artigo', 'post type singular name' ),
            'menu_name'          => _x( 'Artigos', 'admin menu' ),
            'name_admin_bar'     => _x( 'Artigos', 'add new on admin bar' ),
            'add_new'            => _x( 'Adicionar Novo', '' ),
            'add_new_item'       => __( 'Adicionar Novo Artigo' ),
            'new_item'           => __( 'Novao Artigo' ),
            'edit_item'          => __( 'Editar Artigo' ),
            'view_item'          => __( 'Ver Artigo' ),
            'all_items'          => __( 'Todas os Artigos' ),
            'search_items'       => __( 'Pesquisar artigo' ),
            'not_found'          => __( 'Nenhuma atuação encontrado.' ),
            'not_found_in_trash' => __( 'Nenhuma atuação encontrada na Lixeira.' )
        )
    );

    \register_post_type( 'artigos', $args );
}

add_action( 'init', __NAMESPACE__ . '\\register_post_type' );


function pre_get_posts( \WP_Query $query ) {
    if ( ! is_admin() && $query->is_main_query() && is_post_type_archive( 'artigos' ) ) {
        $query->set( 'posts_per_page', 25 );
    }
}

//add_action('pre_get_posts', __NAMESPACE__ . '\\pre_get_posts');