<?php
  $actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
  
  $public_url = $actual_link . '/public';

  // var_dump($public_url);
?>

<!DOCTYPE html>
<html lang="pt-BR">
  <head>
    <meta charset="utf-8">
    <title>Gerador de Assinatura</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- CSS ============================= -->
    <link rel="stylesheet" charset="utf-8" href="<?= $public_url ?>/css/reset.css">
    <link rel="stylesheet" charset="utf-8" href="<?= $public_url ?>/css/grid.css">
    <link rel="stylesheet" charset="utf-8" href="<?= $public_url ?>/css/animate.css">
    <link rel="stylesheet" charset="utf-8" href="<?= $public_url ?>/css/jquery-ui.css">
    <link rel="stylesheet" charset="utf-8" href="<?= $public_url ?>/css/azul/estilo.css">

    <!-- Meta que faz o site manter-se intacto no IE8 e chrome=1-->
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">

    <!-- icones ============================= -->
    <link rel="shortcut icon" href="<?= $public_url ?>/img/ico/icon.ico">
    <link rel="apple-touch-icon" href="<?= $public_url ?>/img/ico/apple-touch-icon.png">
    <link rel="apple-touch-icon" sizes="72x72" href="<?= $public_url ?>/img/ico/apple-touch-icon-72x72.png">
    <link rel="apple-touch-icon" sizes="114x114" href="<?= $public_url ?>/img/ico/apple-touch-icon-114x114.png">

    <!-- scripts emergentes ============================= -->
    <script type="text/javascript">try{Typekit.load();}catch(e){}</script>

    <script src="<?= $public_url ?>/js/jquery.min.js"></script> <!-- JQUERY -->
    <script type="text/javascript">
      // Wait for window load
        $(window).load(function() {
            // Animate loader off screen
            $("#loading").fadeOut(1800);
        });
    </script>

    <!-- HTML5 shim, para IE6-8 suportar elementos html5. E todos os JS são carregados por último apartir daqui. -->
    <!--[if lt IE 9]>
      <script src="public/js/html5.js"></script>
    <![endif]-->
  </head>




  <body class="fade">
    <div id="carregar"><span id="loading">
        <img src="<?= $public_url ?>/img/load/load-azul.gif" />
        <span>.</span><span>.</span><span>.</span>
    </span></div>

        <div class="container16 animated exibir">
          <div class="row">
              <div class="column16"><div class="espaco-page"></div></div>


          <div class="row" style="text-align: center;">
              <div class="column16"><div class="head"><img src="<?= $public_url ?>/img/brand/logo-jamad.png" alt="Logomarca" /></div></div>


          <div class="row">
              <div class="column16"><div class="espaco-page"></div></div>


          <div class="row">
            <div class="column16" style="text-align: center;">
              <div class="topo">
                <i class="icons-tools3"></i>&nbsp;<spam class="letras">Configure sua assinatura de e-mail</spam>
              </div>
          </div>
          </div>

          <div class="row">
            <div class="column16">
              <div class="pages">
                  <form id="form" class="form" name="form" method="post" action="<?= $actual_link ?>/assinatura.php">
                    <input type="hidden" value="<?= $public_url; ?>" name="publicurl" />
                    <input type="text" name="nome" id="nome" class="txt required" placeholder="Nome" value=""/><br />
                    <input type="text" name="funcao" id="funcao" class="txt required" placeholder="Função" value=""/><br />
                    <input type="text" id="" name="telefone" class="txt mask_phone required" placeholder="Telefone" value="" />
                    <input type="text" id="ramal" name="ramal" class="txt" placeholder="Ramal" value="" /><br />
                    <input type="email" name="email" id="email" class="txt required" placeholder="Email" value=""/><br />
                    <br />
                    
                    <div id="doisbt">
                        <input type="submit" name="gravar" value="Criar assinatura" class="enviar"/>
                    </div>
                </form>
              </div>
            </div>
          </div>

          <div class="row">
              <div class="column16"><div class="espaco-page"></div></div>
        </div>


    <!-- Carregando JS aqui =============================-->
    <script src="<?= $public_url ?>/js/respond.min.js"></script> 
    <script src="<?= $public_url ?>/js/modernizr-2.6.1.min.js"></script>
    <script src="<?= $public_url ?>/js/jquery-ui-1.10.0.custom.min.js"></script> 
    <script src="<?= $public_url ?>/js/custom-checkbox-and-radio.js"></script> 
    <script src="<?= $public_url ?>/js/custom-radio.js"></script> 
    <script src="<?= $public_url ?>/js/jquery.validate.js"></script> 
    <script src="<?= $public_url ?>/js/jquery.maskedinput.js"></script> 
    <script src="<?= $public_url ?>/js/validacoes.js"></script>

    <script src="<?= $public_url ?>/js/shuffleLetters.js"></script>
    <script src="<?= $public_url ?>/js/scripts.js"></script>

<body>
</body>
</html>